% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_hy_graph.R
\name{check_hy_graph}
\alias{check_hy_graph}
\title{Check hy Graph}
\usage{
check_hy_graph(x, loop_check = FALSE)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{loop_check}{logical if TRUE, the entire network is walked from
top to bottom searching for loops. This loop detection algorithm visits
a node in the network only once all its upstream neighbors have been
visited. A complete depth first search is performed at each node, searching
for paths that lead to an already visited (upstream) node. This algorithm
is often referred to as "recursive depth first search".}
}
\value{
if no localized loops are found, returns TRUE. If localized
loops are found, problem rows with a row number added.
}
\description{
check that a network graph doesn't contain localized loops.
}
\details{
Required attributes: \code{id}, \code{toid}
}
\examples{
# notice that row 4 (id = 4, toid = 9) and row 8 (id = 9, toid = 4) is a loop.
test_data <- data.frame(id = c(1, 2, 3, 4, 6, 7, 8, 9),
  toid = c(2, 3, 4, 9, 7, 8, 9, 4))
check_hy_graph(test_data)

}
