% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-core.R
\name{gsummary}
\alias{gsummary}
\title{Calculates summary statistics of track expression}
\usage{
gsummary(expr = NULL, intervals = NULL, iterator = NULL, band = NULL)
}
\arguments{
\item{expr}{track expression}

\item{intervals}{genomic scope for which the function is applied}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expression.}

\item{band}{track expression band. If 'NULL' no band is used.}
}
\value{
An array that represents summary statistics.
}
\description{
Calculates summary statistics of track expression.
}
\details{
This function returns summary statistics of a track expression: total number
of bins, total number of bins whose value is NaN, min, max, sum, mean and
standard deviation of the values.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gsummary("rects_track")

}
\seealso{
\code{\link{gintervals.summary}}, \code{\link{gbins.summary}}
}
\keyword{~statistics}
\keyword{~summary}
