% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_matrix.R
\name{rescale_matrix}
\alias{rescale_matrix}
\title{Row-wise rescaling of a matrix to relative frequencies}
\usage{
rescale_matrix(m)
}
\arguments{
\item{m}{Numeric matrix; rows are biological identities, columns are time
bins (i.e., time resources).}
}
\value{
A numeric matrix of the same dimension with each row summing to 1.
Rows with a zero sum are left unchanged (resulting in \code{NaN} if present).
}
\description{
Divides each row by its row sum so that every row sums to 1 (leaving
dimnames intact).
}
\examples{
ex1_rescale <- rescale_matrix(ex1)
rowSums(ex1_rescale)
}
