% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-standalone-df-list-df.R
\name{.df_to_list_of_lists}
\alias{.df_to_list_of_lists}
\title{Convert a nested dataframe to a multilevel list}
\usage{
.df_to_list_of_lists(df, ...)
}
\arguments{
\item{df}{a nested dataframe}

\item{...}{
  Named arguments passed on to \code{\link[=.transpose]{.transpose}}\describe{
    \item{\code{x}}{a \code{data.frame} or \code{row_list}}
\item{\code{.fix}}{collapse or expand names in redundant multi-level \code{row_list}s.
Either \code{FALSE} or a string to join or split the names of the multi-level
list by}
\item{\code{...}}{not used}
}}
}
\value{
a list of lists
}
\description{
Convert a nested dataframe to a multilevel list
}
\concept{transpose}
\keyword{internal}

\section{Unit tests}{
\if{html}{\out{<div class="sourceCode">}}\preformatted{


iris_list = .df_to_list_of_lists(datasets::iris)
# TODO: iris_list has lost Petal.Length as it is interpreting Petal.Width as
# nested item and it overwrites Petal.Length rather than merging with it.

testthat::expect_equal(
  iris_list[[1]]$Species,
  iris$Species[[1]]
)

mtcars_nest = datasets::mtcars %>%
  dplyr::mutate(name = rownames(.)) %>%
  tidyr::nest(details = -c(cyl,gear))

mtcars_list = mtcars_nest %>% .df_to_list_of_lists()

mtcars_unnest = mtcars_list %>% .list_of_lists_to_df()

testthat::expect_equal(
  mtcars_list[[1]]$details[[1]]$name,
  mtcars_nest$details[[1]]$name[[1]]
)

}\if{html}{\out{</div>}}
}

