% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_dist.R
\name{imagedist}
\alias{imagedist}
\title{Wasserstein Distance between Two Images}
\usage{
imagedist(x, y, p = 2)
}
\arguments{
\item{x}{a grayscale image matrix of size \eqn{(m\times n)} with nonnegative entries.}

\item{y}{a grayscale image matrix of size \eqn{(m\times n)} with nonnegative entries.}

\item{p}{an exponent for the order of the distance (default: 2).}
}
\value{
a list containing \describe{
\item{distance}{the Wasserstein distance \eqn{W_p(x,y)}.}
\item{plan}{the optimal transport plan matrix of size \eqn{(mn\times mn)}.}
}
}
\description{
Given two grayscale images represented as numeric matrices, compute their
Wasserstein distance using an exact balanced optimal transport solver. 
Each image is interpreted as a discrete probability distribution on a common \eqn{(m\times n)} grid. 
The ground cost is defined using the Euclidean distance between grid locations.
}
\examples{
\donttest{
#----------------------------------------------------------------------
#                       Small MNIST-like Example
#----------------------------------------------------------------------
# DATA
data(digit3)
x <- digit3[[1]]
y <- digit3[[2]]

# COMPUTE
W1 <- imagedist(x, y, p=1)
W2 <- imagedist(x, y, p=2)

# SHOW RESULTS
print(paste0("Wasserstein-1 distance: ", round(W1$distance,4)))
print(paste0("Wasserstein-2 distance: ", round(W2$distance,4)))
}

}
\concept{image}
