% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_image_series.R
\name{save_extracted_image_series}
\alias{save_extracted_image_series}
\alias{extract_image_series}
\title{Save a series of DICOM image files to a directory}
\usage{
save_extracted_image_series(series_instance_uid, out_dir = NULL,
  verbose = TRUE)

extract_image_series(zip_file, out_dir = NULL)
}
\arguments{
\item{series_instance_uid}{Series instance UID. To get a list of available series instance UIDs, call \code{\link{get_series_info}}.
Note: if \code{series_instance_uid} is invalid, the API may still successfully return an empty zip file.}

\item{out_dir}{Directory to write zip file to}

\item{verbose}{print diagnostic messages}

\item{zip_file}{downloaded zip file, usually output of
\code{\link{save_image_series}}}
}
\value{
List containing elements:
\itemize{
  \item \code{files}: The output zip file that was written
  \item \code{dirs}: Directories of the files
  \item \code{out_file}: The output zip file that was written
  \item \code{response}: API response
}
}
\description{
Save a series of DICOM image files to a directory
}
\examples{
\dontrun{
save_extracted_image_series(
     series_instance_uid = "1.3.6.1.4.1.14519.5.2.1.5382.4002.806935685832642465081499816867")
}

}
