% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdcm.R
\name{tdcm}
\alias{tdcm}
\title{Estimating the Transition Diagnostic Classification Model (TDCM)}
\usage{
tdcm(
  data,
  q.matrix,
  num.time.points,
  invariance = TRUE,
  rule = "GDINA",
  num.q.matrix = 1,
  num.items = c(),
  anchor = c(),
  progress = FALSE
)
}
\arguments{
\item{data}{A required \eqn{N \times T \times I} data matrix containing binary item responses.
For each time point, the binary item responses are in the columns.}

\item{q.matrix}{A required \eqn{I \times A} matrix indicating which items measure which
attributes. If there are multiple Q-matrices, then they must have the same number of attributes
and must be stacked on top of each other for estimation (to specify multiple Q-matrices, see
\code{num.q.matrix}, \code{num.items}, and \code{anchor}).}

\item{num.time.points}{A required integer \eqn{\ge 2} specifying the number of time points (i.e.,
measurement / testing occasions).}

\item{invariance}{logical. If \code{TRUE} (the default), the item parameter invariance will be
constrained to be equal at each time point. If \code{FALSE}, item parameters are not assumed to be
equal over time.}

\item{rule}{A string or a vector of the specific DCM to be employed. Currently accepts the
same values as \code{rule} in \code{\link[CDM:gdina]{CDM::gdina()}}. The default is \code{"GDINA"}, which is implemented with a
logit link to estimate the LCDM. If \code{rule} is supplied as a single string, then that DCM will
be assumed for each item. If entered as a vector, a DCM can be specified for each item.}

\item{num.q.matrix}{An optional integer specifying the number of Q-matrices. For many
applications, the same assessment is administered at each time point and this number is 1 (the
default). If there are different Q-matrices for each time point, then this argument must be
specified and should be equal to the number of time points. For example, if there are three time
points, and the Q-matrix for each time point is different, then \code{num.q.matrix = 3}. If there are
three time points, and the Q-matrix is different only for time point 3, then \code{num.q.matrix} is
still specified as \code{3}.}

\item{num.items}{An optional integer specifying the number of Q-matrices (the default is \code{1}).
when there are multiple Q-matrices, the number of items in each Q-matrix is specified as a
vector of length \code{T}. For example, if there are three time points, and the Q-matrices for each
time point have 8, 10, and 12 items, respectively, then \code{num.items = c(8, 10, 12)}. Default is an
empty vector to indicate there is only one Q-matrix.}

\item{anchor}{When there are different tests at each time point, this optional anchor argument is
a vector of pairs of item numbers indicating which items are the same across time points and
should be held invariant. For example, if there are three Q-matrices with 10 items each, and
Items 1, 11, and 21 are the same, and Items 14 and 24 are the same, then
\code{anchor = c(1,11,1,21,14,24)}. Default is an empty vector to indicate there is only one
Q-matrix.}

\item{progress}{logical. If \code{FALSE} An optional logical indicating whether the function should
print the progress of estimation.}
}
\value{
An object of class \code{gdina} with entries as described in \code{\link[CDM:gdina]{CDM::gdina()}}. To see a
TDCM-specific summary of the object (e.g., growth, transitions), use \code{\link[=tdcm.summary]{tdcm.summary()}}.
}
\description{
\code{tdcm()} is used to estimate the transition diagnostic classification model (TDCM; Madison &
Bradshaw, 2018a), which is a longitudinal extension of the log-linear cognitive diagnosis model
(LCDM; Henson, Templin, & Willse, 2009). It allows for the specification of many specific DCMs
via the \code{rule} option. For the multigroup TDCM, see \code{\link[=mg.tdcm]{mg.tdcm()}}.
}
\details{
Estimation of the TDCM via the \pkg{CDM} package (George, et al., 2016), which is based on an
EM algorithm as described in de la Torre (2011). The estimation approach is further detailed in
Madison et al. (2023).
}
\examples{
\donttest{
## Example 1: T = 2, A = 4
data(data.tdcm01, package = "TDCM")
data <- data.tdcm01$data
q.matrix <- data.tdcm01$q.matrix

# Estimate full TDCM with invariance assumed.
model1 <- TDCM::tdcm(data, q.matrix, num.time.points = 2)

# Summarize results with tdcm.summary().
results <- TDCM::tdcm.summary(model1, num.time.points = 2)
results$item.parameters
results$growth
results$transition.probabilities
}
}
\references{
de la Torre, J. (2011). The generalized DINA model framework. \emph{Psychometrika}, 76, 179-199.

George, A. C., Robitzsch, A., Kiefer, T., Gross, J., & Ünlü , A. (2016). The R package CDM for
cognitive diagnosis models. \emph{Journal of Statistical Software}, 74(2), 1-24.

Henson, R., Templin, J., & Willse, J. (2009). Defining a family of cognitive diagnosis models
using log linear models with latent variables. \emph{Psychometrika}, 74, 191-21.

Madison, M. J., & Bradshaw, L. (2018a). Assessing growth in a diagnostic classification model
framework. \emph{Psychometrika}, 82(4), 963-990.

Madison, M. J., & Bradshaw, L. (2018b). Evaluating intervention effects in a diagnostic
classification model framework. \emph{Journal of Educational Measurement}, 55(1), 32-51.

Madison, M.J., Chung, S., Kim, J., & Bradshaw, L. (2024). Approaches to estimating longitudinal
diagnostic classification models. \emph{Behaviormetrika}, 51, 7-19.
https://doi.org/10.1007/s41237-023-00202-5

Rupp, A. A., Templin, J., & Henson, R. (2010).
\emph{Diagnostic Measurement: Theory, Methods, and Applications}. New York: Guilford.
}
