% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Semi.par.rule.R
\name{Semi.par.rule}
\alias{Semi.par.rule}
\title{Min TMR Semiparametric Rule}
\usage{
Semi.par.rule(Z, S, phi)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}

\item{phi}{Percentage of patients taking viral load test.}
}
\value{
Semiparametric rule and its associated TMR.
}
\description{
This function gives you the optimal semiparametric tripartite rule that minimizes TMR (total misclassification risk).
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
Semi.par.rule( Z, S, phi)
}
\keyword{rules}
\keyword{semiparametric}
