% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/THREC.R
\name{species_specific}
\alias{species_specific}
\title{Species-specific response calibration for Scots pine, Norway spruce, and Birch}
\usage{
species_specific(DATA)
}
\arguments{
\item{DATA}{data frame containing at least yta, rev, t_l, dia, QMD, G, hdom, hojd.}
}
\value{
data frame with estimated height
}
\description{
This function uses the plot- and revision-level random effects to predict missing tree height of Scots pine, Norway spruce and birch. It contains the species-specific height functions.
}
\note{
yta: plot number, rev: revision, t_l: species code (1: Scot pine; 2: Norway spruce; 3: Silver birch; 4: Downy birch), dia: diameter at breast height, QMD: quadratic mean diameter, G: basal area per ha, hdom: height of the tree with the largest diameter (ddom) regardless of the species (m), hojd: sample tree height with missing values. In cases where hdom is not present in the inventory data, site index (SI) can serve as an alternative, although the estimated height may exhibit slight variations.
}
\examples{
library(THREC)

# sample data
data(Treeht)

species_specific(Treeht)
}
\references{
Ogana et al. (2023) https://doi.org/10.1016/j.foreco.2023.120843

Arias-Rodil et al. (2015) https://doi.org/10.1371/JOURNAL.PONE.0143521
}
\seealso{
\code{\link[=main_species]{main_species()}}, which estimate the tree height of the main species based on equation 16 i.e., generalized function with species as a covariate (dummy variable).
}
\author{
Ogana F.N. and Arias-Rodil M.
}
\keyword{species_specific}
