% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HAR.TLineSeg.Centroid.R
\name{HAR.TLineSeg.centroid}
\alias{HAR.TLineSeg.centroid}
\title{Gaussian-like Sampling on a max- or min-plus tropical line segment}
\usage{
HAR.TLineSeg.centroid(D1, D2, m, s, tadd = max)
}
\arguments{
\item{D1}{point in the tropical projective torus}

\item{D2}{point in the tropical projective torus}

\item{m}{location parameter}

\item{s}{scale parameter}

\item{tadd}{function; max indicates max-plus addition, min indicates min-plus
addition. Defaults to max}
}
\value{
point on the line segment defined by D1 and D2 sampled about mu
}
\description{
This function samples points on a tropical line segment about a location
parameter for a given scale parameter defined in terms of tropical distance
}
\examples{
D1 <-c(0,4,2)
D2 <- c(0,7,-1)
m<-c(0,7,2)
s<-1
HAR.TLineSeg.centroid(D1, D2,m,s)
HAR.TLineSeg.centroid(D1, D2,m,s,tadd=min)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
