% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.thyper.R
\name{hyper_3D}
\alias{hyper_3D}
\alias{draw.thyper}
\title{2D or 3D rendering of max-plus or min-plus tropical hyperplane}
\usage{
draw.thyper(D, ext, min.ax, max.ax, plot = FALSE, tadd = max)
}
\arguments{
\item{D}{point in the tropical projective torus representing the apex of the
hyperplane}

\item{ext}{scalar; indicates how far the hyperplane should extend}

\item{min.ax}{scalar; value applied to define the minimum limits of the axes
of the plot}

\item{max.ax}{scalar; value applied to define the maximum limits of the axes
of the plot}

\item{plot}{logical; if true produces a new plot otherwise overlays tropical
hyperplane on existing plot}

\item{tadd}{function; max indicates max-plus addition, min indicates
min-plus addition. Defaults to max}
}
\value{
2D or 3D rendering of max-plus or min-plus tropical hyperplane
}
\description{
This function renders a 2D or 3D max-plus or min-plus tropical hyperplane
}
\examples{
# 2D Example
D <-c(0,0,0)
ext<-4
min.ax<- 5
max.ax<- 5
draw.thyper(D,ext,min.ax,max.ax,plot=TRUE)

# 3D Example
D <-c(0,0,0,0)
ext<-4
min.ax<- 5
max.ax<- 5
draw.thyper(D,ext,min.ax,max.ax,plot=TRUE)
draw.thyper(D,ext,min.ax,max.ax,plot=TRUE,tadd=min)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
