% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.plot.pro.R
\name{pre.pplot.pro}
\alias{pre.pplot.pro}
\title{Projections of points onto a tropical triangle}
\usage{
pre.pplot.pro(S, D)
}
\arguments{
\item{S}{matrix of points representing a tropical polytope; rows are the
vertices}

\item{D}{data points in the tropical projective torus}
}
\value{
matrix of points representing projections of the points in D (row
vectors) onto S
}
\description{
This function produces the a matrix of points projected onto a tropical
triangle defined by the column space of a matrix
}
\examples{
s <- 3 #number of vertices.  Here it is a tropical triangle
d <- 3 ## dimension
N <- 100 ## sample size
D <- matrix(rep(0, N*d), N, d)
D[, 1] <- rnorm(N, mean = 5, sd = 5)
D[, 2] <- rnorm(N, mean = -5, sd = 5)
D[, 3] <- rnorm(N, mean = 0, sd = 5)

index <- sample(1:N, s)
S <- D[index,]

DD <- pre.pplot.pro(S, D)
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
