% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equ_ftest.R
\name{equ_ftest}
\alias{equ_ftest}
\title{Equivalence Test using an F-test}
\usage{
equ_ftest(Fstat, df1, df2, eqbound = NULL, eqb, MET = FALSE, alpha = 0.05)
}
\arguments{
\item{Fstat}{The F-statistic from the F-test.}

\item{df1}{Degrees of freedom for the numerator (effect degrees of freedom).}

\item{df2}{Degrees of freedom for the denominator (error degrees of freedom).}

\item{eqbound}{Equivalence bound for the partial eta-squared. This value represents
the smallest effect size considered meaningful or practically significant.}

\item{eqb}{Defunct argument for equivalence bound, use \code{eqbound} instead.}

\item{MET}{Logical indicator to perform a minimal effect test rather than equivalence
test (default is FALSE). When TRUE, the alternative hypothesis becomes that the effect
is larger than the equivalence bound.}

\item{alpha}{Alpha level used for the test (default = 0.05).}
}
\value{
Object of class "htest" containing the following components:
\itemize{
\item \strong{statistic}: The value of the F-statistic with name "F".
\item \strong{parameter}: The degrees of freedom for the F-statistic (df1 and df2).
\item \strong{p.value}: The p-value for the equivalence or minimal effect test.
\item \strong{conf.int}: A confidence interval for the partial eta-squared statistic.
\item \strong{estimate}: Estimate of partial eta-squared.
\item \strong{null.value}: The specified equivalence bound.
\item \strong{alternative}: NULL (not used in this test).
\item \strong{method}: A string indicating the type of test ("Equivalence Test from F-test" or "Minimal Effect Test from F-test").
\item \strong{data.name}: A string indicating that this was calculated from summary statistics.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Performs equivalence or minimal effect testing on the partial eta-squared (pes) value using
an F-test. This function provides a low-level interface that works directly with F statistics
rather than ANOVA objects.
}
\details{
This function tests whether an effect is practically equivalent to zero (when
\code{MET = FALSE}) or meaningfully different from zero (when \code{MET = TRUE}) using the approach
described by Campbell & Lakens (2021).

The function works by:
\enumerate{
\item Converting the F-statistic to a partial eta-squared value
\item Converting the equivalence bound for partial eta-squared to a non-centrality parameter
\item Computing the confidence interval for the partial eta-squared
\item Performing an equivalence test or minimal effect test based on the non-central F distribution
}

For equivalence tests (\code{MET = FALSE}), a significant result (p < alpha) indicates that the
effect is statistically equivalent to zero (smaller than the equivalence bound).

For minimal effect tests (\code{MET = TRUE}), a significant result (p < alpha) indicates that
the effect is meaningfully different from zero (larger than the equivalence bound).

For details on the calculations in this function see \code{vignette("the_ftestTOSTER")}.
}
\examples{
# Example 1: Equivalence test with a small effect
# F = 2.5, df1 = 2, df2 = 100, equivalence bound = 0.1
equ_ftest(Fstat = 2.5, df1 = 2, df2 = 100, eqbound = 0.1)

# Example 2: Minimal effect test with a large effect
# F = 12, df1 = 3, df2 = 80, equivalence bound = 0.1
equ_ftest(Fstat = 12, df1 = 3, df2 = 80, eqbound = 0.1, MET = TRUE)

# Example 3: Equivalence test with a very small effect
# F = 0.8, df1 = 1, df2 = 50, equivalence bound = 0.05
equ_ftest(Fstat = 0.8, df1 = 1, df2 = 50, eqbound = 0.05)

}
\references{
Campbell, H., & Lakens, D. (2021). Can we disregard the whole model? Omnibus non‐inferiority
testing for R2 in multi‐variable linear regression and in ANOVA. British Journal of
Mathematical and Statistical Psychology, 74(1), 64-89. doi: 10.1111/bmsp.12201
}
\seealso{
Other f-test: 
\code{\link{equ_anova}()}
}
\concept{f-test}
