% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCorrect.R
\name{T_get}
\alias{T_get}
\title{Calculating the adiabatic heating effect.}
\usage{
T_get(x, eta1, rho1, c1, ACorrect1 = 1, manual1 = NULL)
}
\arguments{
\item{x}{A data frame with \code{\link[VBTree:VBTree-package]{VBTree}} style. Pay attention, all factors
in column names should be separated by "-" symbol, and factors for temperatures and strain rates should be
saved in pure numeric style.}

\item{eta1}{Efficiency of deformation heating.}

\item{rho1}{Density of materials, unit is g/cm^3.}

\item{c1}{Heat capacity of materials, unit is J/(kg*K).}

\item{ACorrect1}{Coefficient to modify for density or heat capacity using different units. Default value
is 1.}

\item{manual1}{An integer vector with the length of 3 where the 1st element denotes the layer for Stress and Strain,
the 2nd and 3rd elements represent the levels for Strain and Stress, respectively. The default setting is NULL, which
can call the function \code{\link[TPMplt:lyIDdetector]{lyIDdetector}} for automatical completion this vector.}
}
\value{
A data frame with the identical shape as input data. The values of stress was replaced by adiabatic heating effect.
}
\description{
Calculating the adiabatic heating effect.
}
\examples{
# Constants of steels as example:
T_get(TPMdata, 0.9, 7.8, 502.416)
}
\keyword{internals}
