% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_trex.R
\name{screen_trex}
\alias{screen_trex}
\title{Run the Screen-T-Rex selector (\doi{10.1109/SSP53291.2023.10207957})}
\usage{
screen_trex(
  X,
  y,
  K = 20,
  R = 1000,
  method = "trex",
  bootstrap = FALSE,
  conf_level_grid = seq(0, 1, by = 0.001),
  cor_coef = NA,
  type = "lar",
  corr_max = 0.5,
  lambda_2_lars = NULL,
  rho_thr_DA = 0.02,
  parallel_process = FALSE,
  parallel_max_cores = min(K, max(1, parallel::detectCores(logical = FALSE))),
  seed = NULL,
  eps = .Machine$double.eps,
  verbose = TRUE
)
}
\arguments{
\item{X}{Real valued predictor matrix.}

\item{y}{Response vector.}

\item{K}{Number of random experiments.}

\item{R}{Number of bootstrap resamples.}

\item{method}{'trex' for the T-Rex selector (\doi{10.48550/arXiv.2110.06048}),
'trex+GVS' for the T-Rex+GVS selector (\doi{10.23919/EUSIPCO55093.2022.9909883}),
'trex+DA+AR1' for the T-Rex+DA+AR1 selector,
'trex+DA+equi' for the T-Rex+DA+equi selector.}

\item{bootstrap}{Logical. If TRUE Screen-T-Rex is carried out with bootstrapping.}

\item{conf_level_grid}{Confidence level grid for the bootstrap confidence intervals.}

\item{cor_coef}{AR(1) autocorrelation coefficient for the T-Rex+DA+AR1 selector or equicorrelation coefficient for the T-Rex+DA+equi selector.}

\item{type}{'lar' for 'LARS' and 'lasso' for Lasso.}

\item{corr_max}{Maximum allowed correlation between any two predictors from different clusters.}

\item{lambda_2_lars}{lambda_2-value for LARS-based Elastic Net.}

\item{rho_thr_DA}{Correlation threshold for the T-Rex+DA+AR1 selector and the T-Rex+DA+equi selector (i.e., method = 'trex+DA+AR1' or 'trex+DA+equi').}

\item{parallel_process}{Logical. If TRUE random experiments are executed in parallel.}

\item{parallel_max_cores}{Maximum number of cores to be used for parallel processing.}

\item{seed}{Seed for random number generator (ignored if parallel_process = FALSE).}

\item{eps}{Numerical zero.}

\item{verbose}{Logical. If TRUE progress in computations is shown.}
}
\value{
A list containing the estimated support vector, the automatically selected false discovery rate (FDR) and additional information.
}
\description{
The Screen-T-Rex selector (\doi{10.1109/SSP53291.2023.10207957}) performs very fast variable selection in high-dimensional settings while
informing the user about the automatically selected false discovery rate (FDR).
}
\examples{
data("Gauss_data")
X <- Gauss_data$X
y <- c(Gauss_data$y)
set.seed(123)
res <- screen_trex(X = X, y = y)
selected_var <- res$selected_var
selected_var
}
