% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApEn_C.R
\name{ApEn_C}
\alias{ApEn_C}
\title{ApEn_C}
\usage{
ApEn_C(TS, dim = 2, lag = 1, r = 0.2 * sd(TS))
}
\arguments{
\item{TS}{- given time series}

\item{dim}{- dimension of given time series, default value is 2}

\item{lag}{- downsampling, default value is 1}

\item{r}{- radius of searched areas, default value is 0.2*sd(TS)}
}
\description{
This function computes approximate entropy of given time series. It is implemented in C.
}
\examples{
timser <- rnorm(2000)
ApEn_C(timser)
ApEn_C(timser, r = 0.1*sd(timser))
ApEn_C(timser, dim = 3, r = 0.1*sd(timser))

}
\keyword{ApEn}
\keyword{C}
\keyword{approximate}
\keyword{entropy}
