% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSLSTM.R
\name{ts.lstm}
\alias{ts.lstm}
\title{Long Short Term Memory (LSTM) Model for Time Series Forecasting}
\usage{
ts.lstm(
  ts,
  xreg = NULL,
  tsLag,
  xregLag = 0,
  LSTMUnits,
  DropoutRate = 0,
  Epochs = 10,
  CompLoss = "mse",
  CompMetrics = "mae",
  ActivationFn = "tanh",
  SplitRatio = 0.8,
  ValidationSplit = 0.1
)
}
\arguments{
\item{ts}{Time series data}

\item{xreg}{Exogenous variables}

\item{tsLag}{Lag of time series data}

\item{xregLag}{Lag of exogenous variables}

\item{LSTMUnits}{Number of unit in LSTM layer}

\item{DropoutRate}{Dropout rate}

\item{Epochs}{Number of epochs}

\item{CompLoss}{Loss function}

\item{CompMetrics}{Metrics}

\item{ActivationFn}{Activation function}

\item{SplitRatio}{Training and testing data split ratio}

\item{ValidationSplit}{Validation split ration}
}
\value{
\itemize{
  \item TrainFittedValue: Fitted value of train data
  \item TestPredictedValue: Predicted value of test data
  \item AccuracyTable: RMSE and MAPE of train and test data
}
}
\description{
The LSTM (Long Short-Term Memory) model is a Recurrent Neural Network (RNN) based architecture that is widely used for time series forecasting. Min-Max transformation has been used for data preparation. Here, we have used one LSTM layer as a simple LSTM model and a Dense layer is used as the output layer. Then, compile the model using the loss function, optimizer and metrics. This package is based on Keras and TensorFlow modules.
}
\examples{
\donttest{
y<-rnorm(100,mean=100,sd=50)
x1<-rnorm(100,mean=50,sd=50)
x2<-rnorm(100, mean=50, sd=25)
x<-cbind(x1,x2)
TSLSTM<-ts.lstm(ts=y,xreg = x,tsLag=2,xregLag = 0,LSTMUnits=5, Epochs=2)
}
}
\references{
Paul, R.K. and Garai, S. (2021). Performance comparison of wavelets-based machine learning technique for forecasting agricultural commodity prices, Soft Computing, 25(20), 12857-12873
}
