% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rTSMSN}
\alias{rTSMSN}
\title{Generate the Truncated Scale Mixtures of Skew-Normal Distributions}
\usage{
rTSMSN(n, mu = 0, sigma2 = 1, lambda = 0, nu = NULL, a = -Inf,
  b = Inf, dist = "SN")
}
\arguments{
\item{n}{Number of observations.}

\item{mu}{Location parameter.}

\item{sigma2}{Scale parameter.}

\item{lambda}{Skewness parameter.}

\item{nu}{Shape parameter.  Must be NULL in case of Skew-Normal distribution.  Must be a bidimensional vector in case of skew-contaminated normal distribution (SCN) and contaminated normal distribution (CN).}

\item{a}{Lower bound.}

\item{b}{Upper bound.}

\item{dist}{Distribution to be used:  "SN" for Skew-Normal model, "ST" for Skew-t model, "SSL" for Skew-slash model and "SCN" for Skew-contaminated Normal model.}
}
\value{
Returns a vector with the sample generated according to the distribution and parameters defined.
}
\description{
This function generate random samples from Skew-Normal, Skew-t, Skew-Slash and Skew-Contaminated Normal, using the the inverse method.
}
\details{
For the SMN family, consider lambda = 0. For the Skew-contaminated Normal and Contaminated Normal distribution, each component of the bidimensional vector "nu" must be on (0,1).
}
\examples{
rTSMSN(n = 100, mu = 0, sigma2 = 1, nu = NULL, lambda = 0, a = -Inf, b = Inf, dist = "SN")
}
\references{
Lachos, V. H.; Garay, A. M.; Cabral, C. R. "Moments of truncated scale mixtures of skew-normal distributions." Brazilian Journal of Probability and Statistics (In press).

Basso, Rodrigo M., et al. "Robust mixture modeling based on scale mixtures of skew-normal distributions." Computational Statistics & Data Analysis 54.12 (2010): 2926-2941.
}
