% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mma.r
\name{mma}
\alias{mma}
\title{Multiscale Multifractal Analysis of Time Series Data}
\usage{
mma(smin = 10, smax = 600, qmin = -5, qmax = 5, data, col = "V1",
  theta = -45, phi = 25)
}
\arguments{
\item{smin}{Minimal s scale used, when calculating Fq(s) functions family (default 10)}

\item{smax}{Maximal s scale used, when calculating Fq(s) functions family, has to be multiple of 5 (default 600; in general should be near to N/50, where N is a time series length)}

\item{qmin}{Minimal multifractal parameter q used (default -5)}

\item{qmax}{Maximal cmultifractal parameter q used (deafault 5)}

\item{data}{Time series data}

\item{col}{The color variation of the plot}

\item{theta}{Angle of view}

\item{phi}{Second angle of view}
}
\description{
Multiscale Multifractal Analysis of Time Series Data
}
\examples{
\dontrun{
mma(smax=30, data=timeSeriesData)
}
}

