% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localPOET.R
\name{adaptive_poet_rho}
\alias{adaptive_poet_rho}
\title{Adaptive Selection of the Shrinkage Parameter \eqn{\rho} for POET}
\usage{
adaptive_poet_rho(
  R,
  M0 = 10,
  rho_grid = seq(0.001, 2, length.out = 20),
  epsilon2 = 1e-06
)
}
\arguments{
\item{R}{A numeric matrix of data (e.g., residuals) with dimensions \eqn{T × p}, where \eqn{T}
is the number of observations and \eqn{p} is the number of variables.}

\item{M0}{Integer. The number of observations to leave out between two subsamples when forming groups.
Default is 10.}

\item{rho_grid}{A numeric vector of candidate shrinkage parameters \eqn{\rho}. Default is
\code{seq(0.001, 2, length.out = 20)}.}

\item{epsilon2}{A small positive tuning parameter used as an adjustment in the selection of \eqn{\rho}.
Default is \code{1e-6}.}
}
\value{
A list containing:
\itemize{
  \item \code{best_rho}: The selected optimal shrinkage parameter \eqn{\hat{\rho}} that minimizes the total
  squared Frobenius norm difference.
  \item \code{rho_1}: The lower bound for \eqn{\rho} derived from the minimum eigenvalue criteria (adjusted by \code{epsilon2}).
  \item \code{min_Fnorm}: The minimum total squared Frobenius norm difference achieved.
}
}
\description{
This function selects an optimal shrinkage parameter \eqn{\rho} for the residual covariance
estimation procedure. It does so by dividing the data into groups and comparing a shrunk covariance
matrix (computed on one subsample) to a benchmark covariance (computed on another subsample) using
the Frobenius norm. The candidate \eqn{\rho} that minimizes the total squared Frobenius norm difference
is selected.
}
\details{
The function proceeds as follows:

\enumerate{
  \item The total number of observations \eqn{T} is halved to define \eqn{T_1} and \eqn{T_2}. Specifically:
    \deqn{T_1 = \left\lfloor \frac{T}{2} \times \left(1 - \frac{1}{\log(T)}\right) \right\rfloor}
    \deqn{T_2 = \left\lfloor \frac{T}{2} \right\rfloor - T_1}

  \item The sample is divided into \eqn{\left\lfloor T/(2M_0) \right\rfloor} groups (with \eqn{M_0} observations left out in between).

  \item For each group, two subsamples are defined:
    \itemize{
      \item Subsample 1: the first \eqn{T_1} observations of the group.
      \item Subsample 2: the last \eqn{T_2} observations of the group, after skipping \eqn{M_0} observations following subsample 1.
    }

  \item For each group and a given candidate \eqn{\rho} in \code{rho_grid}, the covariance matrix \eqn{S_1}
        is computed from subsample 1, and then shrunk using soft-thresholding:

        \deqn{S_{1,\text{shrunk}} = \text{soft\_threshold}\left(S_1, \rho \times \text{mean}\left(|S_1|_{\text{off-diag}}\right)\right)}

  \item The total squared Frobenius norm between \eqn{S_{1,\text{shrunk}}}
        and the covariance matrix \eqn{S_2} (from subsample 2) is computed across all groups.

  \item The function scans \code{rho_grid} to find the \eqn{\rho} minimizing total error. Additionally, it computes \eqn{\rho_1}
        as \eqn{\epsilon_2} plus the smallest \eqn{\rho} for which the smallest eigenvalue of the shrunk covariance is positive.
}
}
\keyword{internal}
