% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E.Trim.R
\name{E.Trim}
\alias{E.Trim}
\title{Weight Trimming and Redistribution}
\usage{
E.Trim(dk, L, U)
}
\arguments{
\item{dk}{Vector of original sampling weights.}

\item{L}{Lower bound for weights.}

\item{U}{Upper bound for weights.}
}
\value{
This function returns a vector of trimmed weights.
}
\description{
This function performs a method of trimming sampling weights based on the 
evenly redistribution of the net ammount of weight loss among units whose
weights were not trimmed. This way, the sum of the timmed sampling weights 
remains the same as the original weights.
}
\details{
The function returns a vector of trimmed sampling weigths.
}
\examples{

# Example 1
dk <- c(1, 1, 1, 10) 
summary(dk)
L <- 1
U <- 3.5 * median(dk)
dkTrim <- E.Trim(dk, L, U)
sum(dk)
sum(dkTrim)

# Example 2
dk <- rnorm(1000, 10, 10)
L <- 1
U <- 3.5 * median(dk)
dkTrim <- E.Trim(dk, L, U)
sum(dk)
sum(dkTrim)
summary(dk)
summary(dkTrim)
hist(dk)
hist(dkTrim)
}
\references{
Valliant, R. et. al. (2013), \emph{Practical Tools for Designing and
Weigthing Survey Samples}. Springer.\cr
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas 
y estimacion de parametros}. Editorial Universidad Santo Tomas.
}
\author{
Hugo Andres Gutierrez Rojas <hagutierrezro at gmail.com> with contributions
from Javier Nunez <javier_nunez at inec.gob.ec>
}
