% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparison.R
\name{CompParaSurv}
\alias{CompParaSurv}
\title{Compare Parametric Survival Distribution}
\usage{
CompParaSurv(
  data,
  arm_name = "arm",
  dist1 = "weibull",
  dist0 = NULL,
  eps = 1e-06,
  init1 = NULL,
  init0 = NULL,
  maxit = 10,
  report = FALSE,
  reps = NULL,
  sig = 0.05,
  status_name = "status",
  tau = NULL,
  time_name = "time"
)
}
\arguments{
\item{data}{Data.frame.}

\item{arm_name}{Name of the column containing the treatment group, coded as 1 for
treatment, 0 for reference.}

\item{dist1}{Distribution to fit for the target group. Selected from among:
exp, gamma, gengamma, log-normal, and weibull.}

\item{dist0}{Distribution to fit for the reference group. Same choices as for
the target group. If omitted, defaults to the distribution specified for
the target group.}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{init1}{Initial parameter values for the target group.}

\item{init0}{Initial parameter values for the reference group.}

\item{maxit}{Maximum number of Newton-Raphson iterations.}

\item{report}{Report fitting progress?}

\item{reps}{Number of permutation replicates, if requesting permutation
p-values.}

\item{sig}{Significance level, for constructing confidence intervals.}

\item{status_name}{Name of the status indicator, 1 if observed, 0 if
censored.}

\item{tau}{Optional truncation times for calculating RMST.}

\item{time_name}{Name of column containing the time to event.}
}
\value{
An object of class \code{contrast} containing the following:
\describe{
  \item{Model1}{The fitted model for the target group.}
  \item{Model0}{The fitted model for the reference group.}
  \item{Contrast}{Contrasts of means and medians.}
  \item{RMST}{Contrasts of the RMSTs, if `tau` was specified.}
}
}
\description{
Compares the means and medians of parametric survival distributions fit to
two treatment arms. Available distributions include: exponential, gamma,
generalized gamma, log-normal, and Weibull.
}
\details{
Status should be coded as 0 for censored and 1 for observed. Arm is coded as
0 for reference, 1 for target. Tau is an optional numeric vector of
truncation times for calculating restricted mean survival time, which is the
area under the survival curve up to the specified truncation point.
}
\examples{
\donttest{
set.seed(100)
# Weibull and Weibull, different means and medians.
n <- 1e3

# Generate data.
df1 <- GenData(n = n, dist = "weibull", theta = c(1, 1), p = 0.2)
df1$arm <- 1
df0 <- GenData(n = n, dist = "weibull", theta = c(1, 2), p = 0.2)
df0$arm <- 0
data <- rbind(df1, df0)

# Comparison.
comp <- CompParaSurv(data, dist1 = "weibull")

# Add RMST at time 1.
comp <- CompParaSurv(data, dist1 = "weibull", tau = 1)

# Calculate permutation p-values (slow).
comp <-  CompParaSurv(data, dist1 = "weibull", tau = 1, reps = 100)
}
}
