% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python_to_r.R
\name{python_to_r}
\alias{python_to_r}
\title{Convert Python code to R code}
\usage{
python_to_r(py)
}
\arguments{
\item{py}{A file path or character string containing the Python code to be converted.}
}
\value{
If the input is a character string, the function returns the converted R code as a
        character string. If the input is a file, the function writes the converted R code to a
        new file with the same name and a ".R" extension, and returns the output file path.
}
\description{
This function takes a Python code file or character string as input and attempts to
convert the code to R using the OpenAI API. The function provides feedback on
the total tokens used during the conversion and warns if the output might not be valid R code.
}
\examples{
\dontrun{
# Convert a Python code string to R code
python_code <- "x = 5"
r_code <- python_to_r(python_code)
print(r_code)

# Convert a Python code file to an R code file
python_file <- "path/to/your/python_file.py"
r_file <- python_to_r(python_file)
cat(readLines(r_file), sep = "\n")
}

}
