% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TopSisWM.R
\name{TopSisWM}
\alias{TopSisWM}
\title{Multi-Criteria Method for Decision (TOPSIS)}
\usage{
TopSisWM(TabTo = NULL, P.Pesos = NULL, solpo = NULL, sort.rank = TRUE)
}
\arguments{
\item{TabTo}{A table or matrix containing row and column names, with only numeric values. Default is \code{NULL}.}

\item{P.Pesos}{A vector of weights for each criterion. Must have a weight for each column of the table. The sum of weights must be 1. Default is \code{NULL}.}

\item{solpo}{A vector indicating if each criterion is to be maximized ("+") or minimized ("-"). Must match the number of columns. Default is \code{NULL}.}

\item{sort.rank}{Logical. If \code{TRUE}, the result is ordered by rank. If \code{FALSE}, keeps original input order. Default is \code{TRUE}.}
}
\value{
A matrix with the results of the TOPSIS analysis, including the distance to the positive ideal solution (d+), the distance to the negative ideal solution (d-), the relative closeness (eu), and the final rank.
}
\description{
Assists in the TOPSIS analysis process, designed to return a ranking table with the best option as the analysis proposes. TOPSIS is a technique developed by Hwang and Yoon (1981), assuming the best alternative is closest to the positive ideal solution and farthest from the negative one. (LIU, H. et al., 2019) \url{doi:10.1016/j.agwat.2019.105787}.
}
\examples{
data(Topex1)
Tabela <- Topex1
Pesos <- c(0.5,0.3,0.2)
solucao <- c("-","-","+")
TopSisWM(Tabela, Pesos, solucao)

# Important: use row.names = 1 when importing local data
# Tabela <- read.csv("file.csv", sep=";", h=TRUE, row.names=1)
# Tabela <- read.table("Tabela.txt", h=TRUE, row.names=1)

}
\references{
LIU, H. et al. (2019). Optimizing irrigation frequency and amount to balance yield, fruit quality and water use efficiency of greenhouse tomato. Agricultural Water Management, 226, 1–11.
}
