% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_row_labels.R
\name{collapse_row_labels}
\alias{collapse_row_labels}
\title{Collapse row labels into a single column}
\usage{
collapse_row_labels(x, ..., indent = "  ", target_col = row_label)
}
\arguments{
\item{x}{Input data frame}

\item{...}{Row labels to be collapsed}

\item{indent}{Indentation string to be used, which is multiplied at each indentation level}

\item{target_col}{The desired name of the output column containing collapsed row labels}
}
\value{
data.frame with row labels collapsed into a single column
}
\description{
This is a generalized post processing function that allows you to take groups
of by variables and collapse them into a single column. Repeating values are
split into separate rows, and for each level of nesting, a specified
indentation level can be applied.
}
\examples{
x <- tibble::tribble(
~row_label1, ~row_label2, ~row_label3, ~row_label4, ~var1,
  "A",         "C",         "G",         "M",        1L,
  "A",         "C",         "G",         "N",        2L,
  "A",         "C",         "H",         "O",        3L,
  "A",         "D",         "H",         "P",        4L,
  "A",         "D",         "I",         "Q",        5L,
  "A",         "D",         "I",         "R",        6L,
  "B",         "E",         "J",         "S",        7L,
  "B",         "E",         "J",         "T",        8L,
  "B",         "E",         "K",         "U",        9L,
  "B",         "F",         "K",         "V",        10L,
  "B",         "F",         "L",         "W",        11L
)


collapse_row_labels(x, row_label1, row_label2, row_label3, row_label4)

collapse_row_labels(x, row_label1, row_label2, row_label3)

collapse_row_labels(x, row_label1, row_label2, indent = "    ", target_col = rl)

}
