% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{combine2ts}
\alias{combine2ts}
\title{Combiner 2 ts}
\usage{
combine2ts(a, b)
}
\arguments{
\item{a}{un objet ts unidimensionnel conforme aux règles de assert_ts}

\item{b}{un objet ts unidimensionnel conforme aux règles de assert_ts}
}
\value{
En sortie, la fonction retourne un ts qui contient les valeurs de \code{a}
aux temps de \code{a} et les valeurs de \code{b} aux temps de \code{b}.
}
\description{
La fonction \code{combine2ts} combine (comme c()) 2 time series de
même fréquence (mensuelle ou trimestrielle).
}
\details{
Si \code{a} et \code{b} ont une période en commun, les valeurs de \code{b} écrasent
celles de a sur la période concernée.
Si il existe une période sur laquelle ni \code{a} ni \code{b} ne prennent de valeur
(mais qu'il existe des valeurs à des dates ultérieures et antérieures) alors
le ts en sortie prendra NA sur cette période.
}
\examples{

trim_1 <- stats::ts(rep(1, 4), start = 2021, frequency = 4)

mens_1 <- stats::ts(rep(1, 4), start = 2020, frequency = 12)
mens_2 <- stats::ts(rep(2, 4), start = 2022, frequency = 12)

# La série de PIB est écrasé par trim_1 sur la période temporelle de trim_1
combine2ts(ev_pib, trim_1)

# La période entre les séries temporelles mens_1 et mens_2 est complétée par
# des NA
combine2ts(mens_1, mens_2)

}
