% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadiationFunctions.R
\name{monthly_solar_radiation}
\alias{monthly_solar_radiation}
\title{Average Monthly Solar Radiation}
\usage{
monthly_solar_radiation(lat, lon, doy, elev, T_a, hp, P)
}
\arguments{
\item{lat}{\code{numeric} latitude (degrees).}

\item{lon}{\code{numeric} longitude (degrees).}

\item{doy}{\code{numeric} day of year (1-366).}

\item{elev}{\code{numeric} elevation (meters).}

\item{T_a}{\code{numeric} mean monthly air temperature (C).}

\item{hp}{\code{numeric} mean month relative humidity (percentage).}

\item{P}{\code{numeric} total monthly precipitation (mm).}
}
\value{
\code{numeric} average monthly solar radiation (\ifelse{html}{\out{W m<sup>-2</sup>}}{\eqn{W m^-2}{ASCII}}).
}
\description{
The function estimates average monthly solar radiation (\ifelse{html}{\out{W m<sup>-2</sup> d<sup>-1</sup>}}{\eqn{W m^-2 d^-1}{ASCII}}) using basic topographic and climatic information as input. Cloudiness is stochastically modeled, so output will vary between functional calls. Based on \insertCite{Nikolov1992;textual}{TrenchR}.
}
\examples{
  monthly_solar_radiation(lat  = 47.61, 
                          lon  = -122.33, 
                          doy  = 112, 
                          elev = 1500, 
                          T_a  = 15, 
                          hp   = 50, 
                          P   = 50)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
