% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TsoilFunctions.R
\name{soil_temperature_function}
\alias{soil_temperature_function}
\title{Core Function for Calculating Soil Temperature}
\usage{
soil_temperature_function(j, T_so, params)
}
\arguments{
\item{j}{\code{numeric} the number of the iteration of running the model.}

\item{T_so}{\code{numeric} the initial soil temperature profile in C.}

\item{params}{\code{list} containing the following param, which are described or calculated in \code{\link{soil_temperature}}: \code{SSA, epsilon_so, k_so, c_so, dz, z_r, z0, S, T_a, u, rho_a, rho_so, c_a, TimeIn, dt, shade}.}
}
\value{
Soil temperature profile as a \code{list}.
}
\description{
This function is called to calculate soil temperature as in \insertCite{Beckman1973;textual}{TrenchR}. Parameters are passed as a list to facilitating solving the equations. This function is not intended to be called directly. The energy balance equations are from \insertCite{Porter1973;textual}{TrenchR} and \insertCite{Kingsolver1979;textual}{TrenchR}
}
\examples{
  set.seed(123)
  temp_vector       <- runif(96, min = -10, max = 10)
  wind_speed_vector <- runif(96, min = 0, max = 0.4)
  time_vector       <- rep(1:24, 4)
  solrad_vector     <- rep(c(rep(0, 6), 
                             seq(10, 700, length.out = 6), 
                             seq(700, 10, length.out = 6), 
                             rep(0, 6)),
                           4)
  params            <- list(SSA        = 0.7, 
                            epsilon_so = 0.98, 
                            k_so       = 0.293, 
                            c_so       = 800, 
                            dz         = 0.05, 
                            z_r        = 1.5, 
                            z0         = 0.02, 
                            S          = solrad_vector, 
                            T_a        = temp_vector, 
                            u          = wind_speed_vector, 
                            rho_a      = 1.177, 
                            rho_so     = 1620,
                            c_a        = 1006, 
                            TimeIn     = time_vector, 
                            dt         = 60 * 60, 
                            shade      = FALSE)

soil_temperature_function(j      = 1, 
                          T_so   = rep(20,13), 
                          params = params)



}
\references{
\insertAllCited{}
}
\seealso{
Other soil temperature functions: 
\code{\link{soil_conductivity}()},
\code{\link{soil_specific_heat}()},
\code{\link{soil_temperature_equation}()},
\code{\link{soil_temperature_integrand}()},
\code{\link{soil_temperature}()}
}
\author{
Joseph Grigg
}
\concept{soil temperature functions}
