% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilityFunctions.R
\name{zenith_angle}
\alias{zenith_angle}
\title{Zenith Angle}
\usage{
zenith_angle(doy, lat, lon, hour, offset = NA)
}
\arguments{
\item{doy}{\code{numeric} day of year (1-366). This can be obtained from standard date via \code{\link{day_of_year}}.}

\item{lat}{\code{numeric} latitude (decimal degrees).}

\item{lon}{\code{numeric} longitude (decimal degrees).}

\item{hour}{\code{numeric} hour of the day (0-24).}

\item{offset}{\code{numeric} the number of hours to add to UTC (Coordinated Universal Time) to get local time (improves accuracy but not always necessary). Optional. Defaults to NA.}
}
\value{
\code{numeric} zenith angle (degrees)
}
\description{
The function calculates the zenith angle, the location of the sun as an angle (in degrees) measured from vertical \insertCite{Campbell1998}{TrenchR}.
}
\examples{
  zenith_angle(doy  = 112, 
               lat  = 47.61, 
               lon  = -122.33, 
               hour = 12)

}
\references{
\insertAllCited{}
}
\seealso{
Other utility functions: 
\code{\link{airpressure_from_elev}()},
\code{\link{azimuth_angle}()},
\code{\link{day_of_year}()},
\code{\link{daylength}()},
\code{\link{dec_angle}()},
\code{\link{solar_noon}()},
\code{\link{temperature conversions}}
}
\concept{utility functions}
