% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/trial_sequence.R
\name{ipw_data}
\alias{ipw_data}
\alias{ipw_data<-}
\alias{ipw_data,trial_sequence-method}
\alias{ipw_data<-,trial_sequence-method}
\title{IPW Data Accessor and Setter}
\usage{
ipw_data(object)

ipw_data(object) <- value

\S4method{ipw_data}{trial_sequence}(object)

\S4method{ipw_data}{trial_sequence}(object) <- value
}
\arguments{
\item{object}{\code{trial_sequence} object}

\item{value}{\code{data.table} to replace and update in \verb{@data}}
}
\value{
The data from the \verb{@data} slot of \code{object} used for inverse probability weighting.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Generic function to access and update the data used for inverse probability weighting.

The setter method \code{ipw_data(object) <- value} does not perform the same checks and manipulations
as \code{\link[=set_data]{set_data()}}. To completely replace the data please use \code{\link[=set_data]{set_data()}}. This \verb{ipw_data<-} method allows
small changes such as adding a new column.
}
\examples{
ts <- trial_sequence("ITT")
ts <- set_data(ts, data_censored)
ipw_data(ts)
data.table::set(ipw_data(ts), j = "dummy", value = TRUE)

# or with the setter method:
new_data <- ipw_data(ts)
new_data$x2sq <- new_data$x2^2
ipw_data(ts) <- new_data
}
