## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----install, eval=FALSE------------------------------------------------------
# install.packages("TruncExpFam")

## ----setup--------------------------------------------------------------------
library(TruncExpFam)

## ----sample-------------------------------------------------------------------
x <- rtrunc(100, family = "chisq", df = 14)

## ----stats--------------------------------------------------------------------
set.seed(3067)
x2 <- rtrunc(20, "chisq", df = 14)

set.seed(3067)
x3 <- rchisq(20, 14)

identical(x2, x3)

## ----investigate--------------------------------------------------------------
x2
x3
str(x2)
str(x3)
class(x2)
class(x3)

## ----print--------------------------------------------------------------------
print(x2, details = TRUE)

## ----conclusion---------------------------------------------------------------
identical(as.vector(x2), x3)

## ----wrapper------------------------------------------------------------------
set.seed(2912)
x4 <- rtrunc(1e4, "chisq", df = 14)

set.seed(2912)
x5 <- rtruncchisq(1e4, df = 14)

identical(x4, x5)

## ----pois---------------------------------------------------------------------
y1 <- rtruncpois(1e4, 10)
summary(y1)
var(y1)

## ----truncate-----------------------------------------------------------------
y2 <- rtruncpois(1e4, 10, a = 9, b = 20)
summary(y2)
var(y2)

## ----ml-----------------------------------------------------------------------
lambda <- mlEstimationTruncDist(y2, print.iter = TRUE)
lambda

