% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometric_mean.R
\name{geometric_mean}
\alias{geometric_mean}
\title{Geometric Mean Function}
\usage{
geometric_mean(x = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional numeric vector (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The geometric mean of the vector (for non-interactive mode)
}
\description{
This function calculates the geometric mean of a numeric vector.
Can be used in three modes: simple calculation, learning mode with step-by-step
explanation, or interactive mode for practice.
}
\examples{
data <- c(5,21,12,7,3,9,1)
# Simple calculation
geometric_mean(data)

# Learning mode
geometric_mean(data, learn = TRUE)

# Interactive mode
if(interactive()){
geometric_mean(interactive = TRUE)
}

}
