% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202508.R
\name{distr.table.xy}
\alias{distr.table.xy}
\title{Analysis of a bivariate distribution using cross-tables}
\usage{
distr.table.xy(
  x,
  y,
  freq = "counts",
  freq.type = "joint",
  total = TRUE,
  breaks.x,
  breaks.y,
  adj.breaks = TRUE,
  interval.x = FALSE,
  interval.y = FALSE,
  f.digits = 2,
  p.digits = 0,
  force.digits = FALSE,
  data,
  ...
)
}
\arguments{
\item{x, y}{Unquoted strings identifying the variables whose joint
distribution has to be analysed. \code{x} and \code{y} can be the
name of a vector or a factor in the workspace or the name of one of
the columns in the data frame specified in the \code{data} argument.
Note that in the table \code{x} is displayed on the \emph{rows} and
\code{y} on the \emph{columns}.}

\item{freq}{A character vector specifying the set of frequencies
to be displayed (more options are allowed). Allowed options
(possibly abbreviated) are \code{"counts"},
\code{"percentages"} and \code{"proportions"}.}

\item{freq.type}{A character vector specifying the types of
frequencies to be displayed (more types are allowed).
Allowed options are \code{joint} (default)
for joint frequencies, \code{x|y} (or \code{column}) for the distributions
of \code{x} conditioned to \code{y}, and \code{y|x} (or \code{row}) for
the distributions of \code{y} conditioned to \code{x}.}

\item{total}{Logical value indicating whether the sum of the requested
frequencies should be added to the table; default to \code{TRUE}.}

\item{breaks.x, breaks.y}{Allow to classify the variables \code{x}
and/or \code{y}, if \emph{numerical}, into intervals.
They can be integers indicating the number of intervals of
equal width used to classify \code{x} and/or \code{y}, or
vectors of increasing numeric values defining the endpoints of
the intervals (closed on the left and open
on the right; the last interval is closed on the right too).
To cover the entire range of values taken by one variable,
the maximum and the minimum values should be included between
the first and the last break.
It is possible to specify a set of breaks covering only a portion
of the variable's range.}

\item{adj.breaks}{Logical value indicating whether the endpoints of
intervals of a numerical variable (\code{x} or \code{y})
when classified into intervals should be displayed avoiding
scientific notation; default to \code{TRUE}.}

\item{interval.x, interval.y}{Logical values indicating whether
\code{x} and/or \code{y} are variables measured in classes
(\code{TRUE}). If the detected intervals are not
consistent (e.g. overlapping intervals, or intervals with
upper endpoint higher than the lower one), the variable is
tabulated as it is, even if results are not necessarily
consistent; default to \code{FALSE}.}

\item{f.digits, p.digits}{Integer values specifying the number of
decimals used to round respectively proportions
(default: \code{f.digits=2}) and percentages (default: \code{p.digits=0}).
If the chosen rounding
formats some non-zero values as zero, the number of decimals is increased
so that all values have at least one significant digit, unless the argument
\code{force.digits} is set to \code{TRUE}.}

\item{force.digits}{Logical value indicating whether proportions and
percentages should be forcedly rounded to the number of decimals specified in
\code{f.digits} and \code{p.digits} even if non-zero values are
rounded to zero (default to \code{FALSE}).}

\item{data}{An optional data frame containing \code{x} and/or \code{y}.
If not found in \code{data}, the variables are taken from the environment
from which \code{distr.table.xy()} is called.}

\item{...}{Additional arguments to be passed to low level functions.}
}
\value{
A list whose elements are the requested tables
(converted  to dataframes) listing the values taken
by the two variables arranged in standard
order (logical, alphabetical or numerical order for vectors,
order of levels for factors, ordered intervals for classified
variables or for variables measured in classes)
and the specified joint or conditional types of frequencies.
}
\description{
\code{distr.table.xy()} displays tables of joint or conditional
distributions.
}
\examples{
data(MktDATA, package = "UBStats")

# Character vectors, factors, and discrete numeric vectors
# - Default: joint counts
distr.table.xy(LikeMost, Children, data = MktDATA) 

# - Joint and conditional distribution of x|y
#   counts and proportions, no totals
distr.table.xy(LikeMost, Education, freq = c("counts","Prop"), 
               freq.type = c("joint","x|y"), total = FALSE,
               data = MktDATA)
# - Joint and conditional row and column distributions (\%) 
distr.table.xy(CustClass, Children, freq = "Percentages", 
               freq.type = c("joint","row","column"),
               data = MktDATA)

# Numerical variables classified or measured in classes
# - A numerical variable classified into intervals 
#   and a factor
distr.table.xy(CustClass, TotPurch, 
               breaks.y = c(0,5,10,15,20,35),
               freq = c("Counts","Prop"), freq.type = "y|x", 
               data = MktDATA)

# - Two numerical variables, one measured in classes
#   and the other classified into intervals 
distr.table.xy(Income.S, TotPurch, interval.x = TRUE,
               breaks.y = c(0,5,10,15,20,35),
               freq = c("Counts","Prop"), 
               freq.type = c("row","col"), data = MktDATA)

# Argument force.digits
# - Default: manages possible excess of rounding
distr.table.xy(CustClass, Children, freq = "Percentages", 
               freq.type = c("x|y"),data = MktDATA)
# - Force to the required rounding
distr.table.xy(CustClass, Children, freq = "Percentages", 
               freq.type = c("x|y"), 
               force.digits = TRUE, data = MktDATA)

# Output the list with the requested tables
tables.xy<-distr.table.xy(Income.S, TotPurch, 
                          interval.x = TRUE,
                          breaks.y = c(0,5,10,15,20,35),
                          freq = c("Counts","Prop"), 
                          freq.type = c("joint","row","col"), 
                          data = MktDATA)

}
\seealso{
\code{\link{distr.plot.xy}()} for plotting a bivariate
distribution.

\code{\link{distr.table.x}()} for tabulating a univariate
distribution.

\code{\link{distr.plot.x}()} for plotting a univariate
distribution.
}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
