% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{QMED}
\alias{QMED}
\title{QMED (median annual maximum flow) estimate from catchment descriptors}
\usage{
QMED(
  CDs = NULL,
  DonorIDs = NULL,
  no.Donors = NULL,
  alpha = TRUE,
  UrbAdj = TRUE,
  UrbanExpansion = TRUE,
  UrbMax = 1,
  ReturnDetails = FALSE,
  AREA,
  SAAR,
  FARL,
  BFIHOST,
  URBEXT,
  Exclude = NULL
)
}
\arguments{
\item{CDs}{catchment descriptors derived from either GetCDs or CDsXML}

\item{DonorIDs}{This is one or more gauge reference numbers for the gauges you want te be applied as donors. If more than one donor the argiument needs to be a vector of IDs, such as c(71011, 71023, 69082).}

\item{no.Donors}{This argument is for an automated approach for the number of donors you wish to apply. The closest donors to the subject site (by catchment centroid) will be chosen.}

\item{alpha}{Logical with a default of TRUE. If TRUE the distance between donors and the subject site impacts the donor adjustment.}

\item{UrbAdj}{logical argument with a default of FALSE. If TRUE, an urban adjustment is made to the estimate after the donor procedure.}

\item{UrbanExpansion}{logical argument with a default of TRUE. If TRUE an urban expansion factor is applied to the URBEXT value for the site of interest - using the current year.}

\item{UrbMax}{The maximum URBEXT2015 value permitted for donors}

\item{ReturnDetails}{Logical with a default of FALSE. If TRUE and if donors are used an additional dataframe is returned with all the associated details.}

\item{AREA}{catchment area in km2}

\item{SAAR}{standard average annual rainfall (mm)}

\item{FARL}{flood attenuation from reservoirs and lakes}

\item{BFIHOST}{baseflow index calculated from the catchment hydrology of soil type classification}

\item{URBEXT}{measure of catchment urbanisation}

\item{Exclude}{Site ID of any sites you do not want included in an automated donor adjustment procedure. i.e when no.Donors is used.}
}
\value{
An estimate of QMED from catchment descriptors. If donors are applied and ReturnDetails is TRUE, then an additional data frame is provided with associated details.
}
\description{
Estimated median annual maximum flow from catchment descriptors and donor sites
}
\details{
QMED is estimated from catchment descriptors: QMED = 6.8247*AREA^0.8499*0.1780^(1000/SAAR)*FARL^3.0450*0.0321^(BFIHOST^2) as specified by FEH2025. This QMED model is a multiple linear regression with transformed predictor variables and is trained on log transformed observed QMED values. The following assumptions are therefore applied: the relationship between the transformed independent variables (predictors) and the logarithmically transformed dependent variable (QMED) is linear, observations (observed QMEDs used in calibration) are independent of each other, model and sampling errors are independent of each other, model and sampling errors are normally distributed and have a mean of zero, predictor variables are independent, the cross-correlation of model errors can be described by distance between catchment centroids and the form of the associated correlation matrix is known prior to and for the calibration process. When UrbAdj = TRUE, urban adjustment is applied to the QMED estimate according to the FEH2025 method. The observed donor QMEDs are de-urbanised for the donor process and the donor adjusted rural estimate can then be urban adjusted accordingly (this is done by default). The use of the urban adjustment factor (UrbAdj) assumes that QMED is impacted by urbanisation and this impact can be determined by the URBEXT catchment descriptor. Use of the UrbanExpansion option applies a nationally averaged urban expansion factor to the URBEXT value, tending to overall underestimated urbanisation in more urban catchments and overestimated urbanisation in more rural catchments. Note that the distance-dependent moderation term (alpha) in the one-donor adjustment is not always appropriate, for example in some situations where the subject site is on the same watercourse as the donor. Similarly the two-donor distance-weighting method can give unsuitable results in some situations, for example where a subject site is in between the two donors on the same watercourse.  Finally, for flexibility there is the option to input the relevant catchment descriptors directly rather than using a CDs object.

To derive an appropriate estimate when the donor catchment is urban ensure that DonUrbAdj is TRUE.
}
\examples{
# Get some catchment descriptors and calculate QMED as if it was ungauged, with
# no donors, with one donor, two donors, and 8 donors.
cds_55004 <- GetCDs(55004)
QMED(cds_55004)
QMED(cds_55004, DonorIDs = 55012)
QMED(cds_55004, DonorIDs = c(55012, 60007))
QMED(cds_55004, no.Donors = 8)

}
\author{
Anthony Hammond
}
