---
output:
  html_document: default
  pdf_document: default
editor_options: 
  markdown: 
    wrap: 72
---

# NEWS

### Version 0.1.0 (First public release)

2025-12-20

1. [MIINOR CHANGE] Commented out unnecessary `print()`
    and `cat()` function calls in 
    R/telescoped.chisq.plot.R, 
    R/telescoped.gtest.plot.R, and
    R/telescoped.upsilon.plot.R.
1. [MIINOR CHANGE] Revised the package title 
    to "Another Test of Association for Count Data"
    from "Test of Association for Count Data"
1. [IMPROVEMENT] The fast methods of tests now
    accept categorical variables in all basic 
    vector types including character vector,
    integer vector, an numeric vector.

2025-12-14

1. [IMPROVEMENT] Updated documentation for
`upsilon.test()` with more examples with visualizations.
1. [MAJOR CHANGE] Marked most functions in the package
  as internal, as they are under development. 
  The three exported functions are thoroughly
  tested.
1. [MINOR CHANGE] Updated documentation for 
`modified.chisq.test()` and `modified.gtest()`. 
1. [MIINOR CHANGE] Changed the package title 
    to "Test of Association for Count Data"
    from "Upsilon Test of Association for Count Data" 
    to deal with a complaint from CRAN check.

2025-12-13

1. [IMPROVEMENT] Revised the vignette of examples to
make it accessible to the user. Renamed the vignette
file name and title. Rewrote the text. Adjusted
the plots.

2025-12-12

1. [IMPROVEMENT] Updated `telescoped.*` plotting 
functions to use `plot_matrix()` and 
return `ggplot` objects.
1. [IMPROVEMENT] Updated `upsilon.gof.statistic()` 
and `upsilon.gof.test()` with `rescale.p`
parameter for probability normalization control.
1. [IMPROVEMENT] Refactored Vignettes to RMarkdown 
format with optimized 2x2 figure layouts.

2025-12-11

1. Created version 0.1.0 from version 0.0.4.8
1. [IMPROVEMENT] Added strict input validation 
(length checks, non-negative checks) to 
all statistical functions.
1. [NEW FEATURE] Introduced new function 
`plot_matrix()` for `ggplot2`-based balloon 
plots and heatmaps.

### Version 0.0.4.8

2025-09-29

1. Added table_with_shapes function

### Version 0.0.4.7

         
2024-11-12

1. Added table_with_circles function


### Version 0.0.4.6

         
2024-10-01

1. Added Mutual Information in gtest


### Version 0.0.4.5

         
2023-10-25

1. The second priority telescoped test order is from small to large focus
2023-10-24
2. Changed point plot

2023-09-04

3. Changed test_that test cases significant digits to 7.
4. Added No-NA Pearson's Chi-squared Test result for R and CPP
5. Added No-NA G-Test result for R and CPP

2023-09-03

6. Added telescoped.chisq.plot.R
7. Added telescoped.chisq.test.R
8. Added telescoped.data.R
9.  Added telescoped.gtest.plot.R
10. Added telescoped.gtest.R
11. Added telescoped.upsilon.plot.R
12. Added telescoped.upsilon.test.R

2023-09-01

13. Changed function name upsilon() to fast.upsilon.test()
14. Changed function name chisq() to fast.chisq.test()
15. Changed function name gtest() to fast.gtest()
2023-08-25
16. Added gtest.R
2023-08-24
17. Added chisq.R


### Version 0.0.4.4

         
2023-04-17

1. Updated document of upsilon()


### Version 0.0.4.3

         
2023-04-09

1. Added if in upsilon.R

2023-04-06

1. Added upsilon() function condition in "upsilon_cpp.cpp"

 
2023-04-04

1. Added avg = n/(nr*nc). Changed n/(nr*nc) to "avg" and move "avg" outside of sum. From dividing by "avg" each time to dividing by "avg" only once when computing statistics.


2023-04-02

1. Fixed Warning message:
In n * nr * nc : NAs produced by integer overflow
in "upsilon.test.R" 
2. Changed some codes to make the layout more concise and beautiful 
in "upsilon.test.R", "upsilon.gof.test.R", "modified.chisq.test.R", and "modified.GTest.R".
3. Added the following line
   // [[Rcpp::interfaces(r, cpp)]]
in "modified_chisq_statistic_cpp.cpp" and "upsilon_gof_statistic_cpp.cpp".
4. Switched row-by-row to column-by-column traverse in modified_chisq_statistic_cpp().
5. Changed line 64 names(ESTIMATE)  = "Cramér's V" to names(ESTIMATE)  = "Cram\uE9r's V" in "modified.chisq.test.R"

2023-03-23

1. The upsilon_statistic_cpp() has been optimized to speed up by a factor of two. In traversing an Rcpp NumericMatrix, accessing elements column wise can be much faster than row wise. We saw 2 times speedup on 10,000x10,000 matrix after we switched row-by-row to column-by-column traverse.

2023-03-09

1. Added the following line
   // [[Rcpp::interfaces(r, cpp)]]
in "upsilon_statistic_cpp.cpp" to export the upsilon_statistic_cpp() C++ function to other packages.

2023-02-28

1. Added conclusions in Table 7（according to the author）in vignette "upsilon_test.Rmd".

2023-02-22

1. Added legend for stars_pval() in vignette "upsilon_test.Rmd".
2. Interpreted the conclusions in Table 7.
3. Placed the tables(1-5) below the description. 

2023-02-20

1. Added test cases using testthat (requested 2023-02-18)
2. Deleted the "doc" folder, which seems to contain another old copy of the vignette. (requested 2023-02-18)
3. Revised the note under 2023-02-14. (requested 2023-02-19)

2023-02-19

1. Updated the vignette "NEWS.md"
2. Updated DESCRIPTION, REFERENCES.bib.
3. Updated R manual inside "upsilon.test.R" 

2023-02-18

1. Updated the vignette "upsilon_test.Rmd"
2. Updated DESCRIPTION, REFERENCES.bib.
3. Updated the R manual for all R functions.

2023-02-14

1. Effect size changed (From (Upsilon statistic/max Upsilon statistic) to sqrt(Upsilon statistic/max Upsilon statistic)). 
The reason for taking the square root is to normalize the Upsilon statistic so that it falls between 0 and 1, which makes it easier to interpret the strength of the association between the variables. When the except value are all same in a 2x2 table, the Upsilon statistic is as same as Pearson's chisq-test, the effect size is also same.

14. Added Table 6 and Table 7 in vignette "upsilon_test.Rmd".

2023-02-07

1. Added comparisons with Fisher’s exact test in vignette "upsilon_test.Rmd".

2023-02-02

1. Removed compare.results from vignettes.


### Version 0.0.4.2

         
2022-07-01

1. Corrected the residual matrix calculation for the upsilon.test().

2022-06-29

1. Added effect size as the estimate in the return of the Upsilon test. MS. 

2022-06-16

1. Created version 0.0.4.2 from 0.0.4.1.
2. Renamed statistic.cpp() to upsilon.statistic(). (Requested 2022-06-16)
3. Added function modified.chisq.statistic(). (Requested 2022-06-16)


### Version 0.0.4.1

         
2022-06-16

1. Changed the return of statistic.cpp() and gof.statistic.cpp() from a list to a numeric.
2. Updated the tests due to the changes in 1.

2022-06-15

1. Created version 0.0.4.1
2. For the modified.chisq.test function changed the estimate to be the Cramer's V. The current implementation is V^2. (Requested 2022-06-01)
3. Moved the comparison with other methods to vignettes (compare.results.R, auc.plot ) (Requested 2022-06-08)
4. Moved the non-essential packages in the "Imports:" field to  "Suggests:" field in DESCRIPTION. (Requested 2022-06-08)
5. Deleted "test.cpp" from the src folder. (Requested 2022-06-08)


### Version 0.0.4

2022-04-06

1. Created version 0.0.4.

### Version 0.0.3

2022-01-06

1. Created version 0.0.3.

### Version 0.0.2

2021-12-23

1. Created version 0.0.2.

### Version 0.0.1

2021-03-27

1. Created version 0.0.1.

### Version 0.0.0

2021-03-11

1. Created version 0.0.0.
