% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.chisq.test.R
\name{fast.chisq.test}
\alias{fast.chisq.test}
\title{Fast Zero-Tolerant Pearson's Chi-squared Test of Association}
\usage{
fast.chisq.test(x, y, log.p = FALSE)
}
\arguments{
\item{x}{a vector to 
specify observations of the first 
categorical variable. The vector can be of
numeric, character, or logical type.
\code{NA} values must be removed or
replaced before calling the function.}

\item{y}{a vector to specify observations of 
the second categorical variable. 
  Must not contain \code{NA} values and 
  must be of the same length as \code{x}.}

\item{log.p}{a logical. If \code{TRUE}, 
the \emph{p}-value is calculated in
closed form to \strong{natural logarithm} of \emph{p}-value 
to improve numerical precision when
\emph{p}-value approaches zero.
Defaults to \code{FALSE}.}
}
\value{
A list with class \code{"htest"}
  containing the following components:
\item{statistic}{the value of chi-squared test statistic.}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \emph{p}-value of the test.}
\item{estimate}{Cramér's \emph{V} statistic representing the effect size.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of input data.}
}
\description{
Performs a fast zero-tolerant 
Pearson's chi-squared test 
\insertCite{pearson1900}{Upsilon} 
to evaluate association between observations
from two categorical variables.
}
\note{
The test uses an internal 
  hash table, instead of matrix, to
  store the contingency table. Savings in 
  both runtime and memory saving can be
  substantial if the contingency table is 
  sparse and large. The test is implemented
  in C++, to give an additional layer of
  speedup over an R implementation.
}
\examples{
library("Upsilon")
weather <- c(
  "rainy", "sunny", "rainy", "sunny", "rainy"
)
mood <- c(
  "wistful", "upbeat", "upbeat", "upbeat", "wistful"
)

fast.chisq.test(weather, mood)

# The result is equivalent to: 
modified.chisq.test(table(weather, mood))
}
\references{
\insertRef{pearson1900}{Upsilon}
}
