% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.VEwaning.R
\name{plot}
\alias{plot}
\alias{plot.VEwaning}
\title{Plot Analysis Results}
\usage{
\method{plot}{VEwaning}(x, y, ..., xlim)
}
\arguments{
\item{x}{An object of class VEwaning. The object returned by a call to
veWaning()}

\item{y}{Ignored}

\item{...}{Ignored}

\item{xlim}{A numeric vector object. The minimum and maximum tau values
to include in the plot.}
}
\value{
No return value, called to produce graphical elements.
}
\description{
Plot the Estimated Vaccine Efficacy
}
\examples{
data(veWaningData)

set.seed(1234)

ind <- sample(1:nrow(x = veWaningData), 2500, FALSE)

# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.

res <- veWaning(data = veWaningData[ind,], 
                L = 52,  
                lag = 6,  
                modelGam1 = ~ X1+X2+A+A:X1+A:X2, 
                modelGam2 = ~ X1+X2, 
                modelEntry = ~ X1+X2, 
                modelPsiGam1 = ~ X1+X2, 
                modelPsiGam2 = ~ X1+X2, 
                gFunc = 'piece', 
                v = c(15,30))

plot(x = res)
}
