% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_effects.R
\name{visualize_effects}
\alias{visualize_effects}
\title{Visualization for Conversions of Effect Sizes}
\usage{
visualize_effects(
  d,
  circle_color = "lightblue",
  circle_fill = "grey",
  percent_color = "black",
  percent_size = 12,
  text_color = "black",
  font_family = "Times"
)
}
\arguments{
\item{d}{d effect size to convert to other numbers}

\item{circle_color}{a color name or code for the highlighted part of the
donut circle}

\item{circle_fill}{a color name or code for the rest of the circle}

\item{percent_color}{a color name or code for the text of the
effect size}

\item{percent_size}{a numeric value representing the font size of the
larger effect size text inside the circle}

\item{text_color}{a color name or code that changes the color of the
effect size text label}

\item{font_family}{A font family name for the font of the effect
size text label}
}
\value{
Returns a pretty graph of all the effects

\item{graph}{ggplot object of converted effect sizes}
}
\description{
This function displays a visualization the same effect in
various effect sizes including d, f, \eqn{f^2}, proportion
overlap, correlation, number needed to treat, and more.
}
\examples{

visualize_effects(d = .25)

}
\keyword{effect}
\keyword{estimation}
\keyword{ggplot}
\keyword{size}
\keyword{visualization}
