% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableplot.colldiag.R
\name{tableplot.colldig}
\alias{tableplot.colldig}
\alias{tableplot.lm}
\alias{tableplot.glm}
\alias{tableplot.colldiag}
\title{Tableplot for Collinearity Diagnostics}
\usage{
\method{tableplot}{lm}(values, ...)

\method{tableplot}{glm}(values, ...)

\method{tableplot}{colldiag}(
  values,
  prop.col = c("white", "pink", "red"),
  cond.col = c("#A8F48D", "#DDAB3E", "red"),
  cond.max = 100,
  prop.breaks = c(0, 20, 50, 100),
  cond.breaks = c(0, 5, 10, 1000),
  show.rows = nvar:1,
  title = "",
  patterns,
  ...
)
}
\arguments{
\item{values}{A \code{"colldiag"}, \code{"lm"} or \code{"glm"} object}

\item{...}{other arguments, for consistency with generic}

\item{prop.col}{A vector of colors used for the variance proportions. The default is \code{c("white", "pink", "red")}.}

\item{cond.col}{A vector of colors used for the condition indices}

\item{cond.max}{Maximum value to scale the white squares for the condition indices}

\item{prop.breaks}{Scale breaks for the variance proportions}

\item{cond.breaks}{Scale breaks for the condition indices}

\item{show.rows}{Rows of the eigenvalue decompositon of the model matrix to show in the display. The default \code{nvar:1}
puts the smallest dimensions at the top of the display.}

\item{title}{title used for the resulting graphic}

\item{patterns}{pattern matrix used for table plot.}
}
\value{
None. Used for its graphic side-effect
}
\description{
These methods produce a tableplot of collinearity diagnostics, showing the condition indices and variance
proportions for predictors in a linear or generalized linear regression model. This encodes the
condition indices using \emph{squares} whose background color is red for condition indices > 10,
green for values > 5 and green otherwise, reflecting danger, warning and OK respectively.
The value of the condition index is encoded within this using a white square proportional to the value
(up to some maximum value, \code{cond.max}),

Variance decomposition proportions are shown by filled \emph{circles} whose radius is proportional to those values
and are filled (by default) with shades ranging from white through pink to red. Rounded values of those diagnostics
are printed in the cells.
}
\examples{
# None yet

}
\references{
Friendly, M., & Kwan, E. (2009).
"Where’s Waldo: Visualizing Collinearity Diagnostics." \emph{The American Statistician}, \bold{63}, 56–65.
Online: \url{https://www.datavis.ca/papers/viscollin-tast.pdf}.
}
\author{
Michael Friendly
}
