% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_distance.R
\name{axis_distance}
\alias{axis_distance}
\title{Computes points distance to an axis of the cartesian coordinates system.}
\usage{
axis_distance(data, axis, message)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud or voxel cloud.}

\item{axis}{charecter. Specifying the reference axis to compute the distance: "X", "Y" or "Z".}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
A vector containing the distance values of the points
}
\description{
Computes points distance to an axis of the cartesian coordinates system.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- compute distance to the Z axis
tls[,dist:=VoxR::axis_distance(tls,"Z")]

#- round distance values for visualization
tls[,dist:=round(dist*100)]

#- plot the distance to the Z axis
cols=rev(rainbow(max(tls$dist)+1,end=4/6)) # color scale
rgl::open3d()
rgl::plot3d(tls,col=cols[tls$dist+1],add=TRUE)
}
\references{
Lecigne, B., Delagrange, S., & Messier, C. (2018). Exploring trees in three dimensions: VoxR, a novel voxel-based R package dedicated to
            analysing the complex arrangement of tree crowns. Annals of botany, 121(4), 589-601.
}
