% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harcon.R
\name{harcon}
\alias{harcon}
\title{Scrapes harmonic constituent data from NOAA CO-OPS website}
\usage{
harcon(station)
}
\arguments{
\item{station}{station ID number or vector of IDs, available on CO-OPS 
website (\url{https://www.tidesandcurrents.noaa.gov/stations.html?type=Water+Levels}).}
}
\value{
a dataframe of harmonic constituents and their associated phases, 
amplitudes, and speeds.
}
\description{
Scrapes harmonic constituent data from NOAA CO-OPS 
website. Requires an internet connection.
}
\examples{
\dontrun{
bport.cons <- harcon(8467150) # Bridgeport, CT
bport.cons
} 
}
