% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WACSplot.R
\name{WACSplot}
\alias{WACSplot}
\title{Produces validation and/or WACS comparison plots}
\usage{
WACSplot(wacsvalid, file = NULL)
}
\arguments{
\item{wacsvalid}{Output, as obtained when calling \link{WACSvalid} or \link{WACScompare}}

\item{file}{File in which to write the figure. Default is \code{NULL}. If \code{file=NULL}, no file 
is produced; the figure is only produced in the graphical interface}
}
\value{
No return. A Figure is either displayed or printed in a file.
}
\description{
For plotting validation figures from outputs generated when calling \link{WACSvalid} or \link{WACScompare}.
Figures are either displayed or printed in a file
}
\examples{
\dontrun{
  ## Simple example
  data(ClimateSeries)
  ThisData = WACSdata(ClimateSeries)
  ThisPar  = WACSestim(ThisData)
  ThisSim  = WACSsimul(ThisPar, from="1995-01-01", to="2012-12-31")
  ThisVal  = WACSvalid(what="Sim",wacsdata = ThisData, wacspar = ThisPar, 
                       wacssimul = ThisSim,varname="tmin")
  WACSplot(ThisVal,file="ThisFile.pdf")
}

}
