% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WACSplotdensity.R
\name{WACSplotdensity}
\alias{WACSplotdensity}
\title{For plotting fitted bivariate densities of residuals}
\usage{
WACSplotdensity(
  wacsdata = NULL,
  wacspar = NULL,
  season,
  dimens = c(1, 2),
  dry = T,
  DIR = "./"
)
}
\arguments{
\item{wacsdata}{WACS data obtained when calling \link{WACSdata} on original climate series}

\item{wacspar}{WACS parameters estimated when calling \link{WACSestim}}

\item{season}{season to be considered (a scalar)}

\item{dimens}{a vector of length 1 or 2 indicating the marginals to be plotted}

\item{dry}{indicates whether dry weather states (if \code{dry=TRUE}) or wet weather states (if \code{dry=FALSE}) must be considered}

\item{DIR}{Directory in which saving the Figures}
}
\description{
For plotting fitted bivariate densities of residuals
}
\note{
If \code{length(dimens)=1}, the bivariate density of the variable at days \code{(d,d+1)} is plotted. 
If \code{length(dimens)=2}, the same-day bivariate density of the pair of variables is plotted.
}
\examples{
\dontrun{
  ## Simple example
  data(ClimateSeries)
  ThisData = WACSdata(ClimateSeries)
  ThisPar  = WACSestim(ThisData)
  WACSplotdensity(ThisData,ThisPar,season=2,dimens=c(2,3),dry=TRUE) 
}

}
