% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WallomicsData-package.R
\docType{data}
\name{Ecotype}
\alias{Ecotype}
\title{Ecotype}
\format{
A factor with 5 levels of \emph{A. thaliana} genotypes.
}
\source{
\doi{10.3390/cells9102249}
}
\usage{
data("Ecotype")
}
\description{
The \strong{Ecotype factor} identifies the genotype specifically designed for a
given ecosystem of the \emph{A. thaliana} from which the studied sample comes from. We have a population of reference as well as
4 newly-described Pyrenean populations, namely:
\itemize{
\item Columbia, denoted \emph{Col} (originating from Poland, acts as the reference ecotype)
\item Grip, denoted \emph{Grip}
\item Herran, denoted \emph{Hern}
\item L’Hospitalet-près-l’Andorre, denoted \emph{Hosp}
\item Chapelle Saint Roch, denoted \emph{Roch}
}
}
\examples{
# Load the data
data("Ecotype")

# Count how many samples are in each group
table(Ecotype)

}
\keyword{datasets}
