% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-data.R
\name{augment_cycle_data}
\alias{augment_cycle_data}
\alias{augment_year_data_with_month_resolution}
\alias{augment_year_data_with_second_resolution}
\title{Calculates variables necessary for WATS Plots}
\usage{
augment_year_data_with_month_resolution(ds_linear, date_name)
augment_year_data_with_second_resolution(ds_linear, date_name)
}
\arguments{
\item{ds_linear}{The \link{data.frame} to containing the detailed data.}

\item{date_name}{The variable name in \code{ds_linear} containing the date or datetime value.}
}
\value{
Returns a \link[tibble:tibble]{tibble::tibble} with additional variables:
\code{cycle_tally}, \code{proportion_through_cycle}, \code{proportion_id}, and \code{terminal_point_in_cycle}.
}
\description{
Calculates variables necessary for WATS Plots.  This the first of two functions
that needs to be called to produce WATS Plots.  \code{\link[=annotate_data]{annotate_data()}} is the second.
}
\examples{
library(Wats)
ds_linear <-
  Wats::county_month_birth_rate_2005_version |>
  dplyr::filter(county_name == "oklahoma") |>
  augment_year_data_with_month_resolution(date_name = "date")

head(ds_linear)

}
