% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{AllGenerics_component}
\alias{AllGenerics_component}
\alias{worm_membership}
\alias{worm_clustering}
\alias{worm_evaluate}
\alias{worm_visualize}
\title{Components for WormTensor object}
\usage{
worm_membership(object, k)

worm_clustering(
  object,
  algorithm = c("MCMI", "OINDSCAL", "CSPA"),
  num.iter = 30,
  thr = 1e-10,
  verbose = FALSE
)

worm_evaluate(object, labels = NULL)

worm_visualize(
  object,
  out.dir = tempdir(),
  algorithm = c("tSNE", "UMAP"),
  seed = 1234,
  tsne.dims = 2,
  tsne.perplexity = 15,
  tsne.verbose = FALSE,
  tsne.max_iter = 1000,
  umap.n_neighbors = 15,
  umap.n_components = 2,
  silhouette.summary = FALSE
)
}
\arguments{
\item{object}{WormTensor object}

\item{k}{Assumed number of clusters}

\item{algorithm}{Dimensional reduction methods}

\item{num.iter}{The upper limit of iterations (Default value is 30)}

\item{thr}{The lower limit of relative change in estimates
(Default value is 1E-10)}

\item{verbose}{Control message}

\item{labels}{Labels for external evaluation}

\item{out.dir}{Output directory (default: tempdir())}

\item{seed}{Arguments passed to set.seed (default: 1234)}

\item{tsne.dims}{Output dimensionality (default: 2)}

\item{tsne.perplexity}{Perplexity paramete (default: 15)}

\item{tsne.verbose}{logical; Whether progress updates should be printed
(default: TRUE)}

\item{tsne.max_iter}{The number of iterations (default: 1000)}

\item{umap.n_neighbors}{The size of local neighborhood (default: 15)}

\item{umap.n_components}{The dimension of the space to embed into
(default: 2)}

\item{silhouette.summary}{logical; If true a summary of
cluster silhouettes are printed.}
}
\description{
These are generic methods for WormTensor
}
