% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R, R/ProxyClass.R
\docType{methods}
\name{objectAsJSON}
\alias{objectAsJSON}
\alias{objectAsJSON,array-method}
\alias{objectAsJSON,environment-method}
\alias{objectAsJSON,list-method}
\alias{objectAsJSON,envRefClass-method}
\alias{objectAsJSON,Interface-method}
\alias{objectAsJSON,AssignedProxy-method}
\alias{objectAsJSON,ProxyClassObject-method}
\title{Construct a String in JSON Notation to Represent an R Object}
\usage{
objectAsJSON(object, prototype = prototypeObject(), level = 1)

\S4method{objectAsJSON}{array}(object, prototype = prototypeObject(),
  level = 1)

\S4method{objectAsJSON}{environment}(object, prototype = prototypeObject(),
  level = 1)

\S4method{objectAsJSON}{list}(object, prototype = prototypeObject(),
  level = 1)

\S4method{objectAsJSON}{envRefClass}(object, prototype = prototypeObject(),
  level = 1)

\S4method{objectAsJSON}{Interface}(object, prototype = prototypeObject(),
  level = 1)

\S4method{objectAsJSON}{AssignedProxy}(object, prototype = prototypeObject(),
  level = 1)

\S4method{objectAsJSON}{ProxyClassObject}(object,
  prototype = prototypeObject(), level = 1)
}
\arguments{
\item{object}{The object to be converted.}

\item{prototype}{The prototype server class; see \code{\link{asServerObject}}.}

\item{level}{Will be 1 for top-level call, incremented when recalled for an element.
Used to make choices about scalars.}
}
\value{
A string that will be parsed according to JSON grammar.
}
\description{
The XR structure requires a server-language function \code{objectFromJSON()} which
parses an object description in JSON.  Methods for generic function \code{objectAsJSON()}
should produce the appropriate string.
}
\details{
This function is typically called from a method for \code{\link{asServerObject}}.
Methods for \code{objectAsJSON()} in turn often call one or both of two helper functions:
\code{\link{asJSONS4}()}, which produces the full description of the \R object; and
\code{\link{typeToJSON}()}, which produces the code for the basic \R types, ignoring all
class or attribute information.
}
\section{Methods (by class)}{
\itemize{
\item \code{array}: treat matrix and array objects as legitimate S3 objects

\item \code{environment}: An environment is encoded with its class, in contrast to a named list
which may be a simple dictionary.

\item \code{list}: A list will be encoded as a JSON list if it has no names, as a JSON
dictionary if it has all distinct, non-empty names, or with an explicit representation in
all other cases.

\item \code{envRefClass}: An explicit representation that includes the fields.

\item \code{Interface}: An interface object is transmitted via its character string Id,
enough to identify the object; the rest is too R-dependent to be useful.

\item \code{AssignedProxy}: Gets the object back from the server, then recalls the generic.
It's usually not a good idea to get here, because bringing the proxy back and then converting
it again is not foolproof; better to make direct use of the proxy.  But if a proxy object
is part of an ordinary list, environment or other R object, this method will be used.

\item \code{ProxyClassObject}: Gets the object back from the server, then recalls the generic.
See the comments under the \code{"AssignedProxy"} method.
}}

\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 13, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}
