% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_kde2d.R
\name{entropy_kde2d}
\alias{entropy_kde2d}
\title{Shannon entropy in two dimensions}
\usage{
entropy_kde2d(x, y, n_grid = 150)
}
\arguments{
\item{x}{numeric, random vector}

\item{y}{numeric, random vector}

\item{n_grid}{numeric, number of grid cells to evaluate density}
}
\value{
A numeric value of the entropy in 2D
}
\description{
Shannon entropy in two dimensions
}
\examples{
set.seed(123)
# Generate a 2D normal distribution with a correlation of 0.6
n <- 1000
mean <- c(0, 0)
sd_x <- 1
sd_y <- 5
correlation <- 0.6
sigma <- matrix(
  c(
    sd_x^2,
    correlation * sd_x * sd_y,
    correlation * sd_x * sd_y,
    sd_y^2
  ),
  ncol = 2
)
library(MASS)
simulated_data <- mvrnorm(n, mu = mean, Sigma = sigma)
x <- simulated_data[, 1]
y <- simulated_data[, 2]

cov_matr <- cov(cbind(x, y))
sigmas <- diag(cov_matr)
det_sig <- prod(sigmas)
# According to https://en.wikipedia.org/wiki/Multivariate_normal_distribution#Differential_entropy:

normal_entropy <- function(k, pi, det_sig) {
  # The left part is a constant;
  (k / 2) * (1 + log(2 * pi)) + (1 / 2) * log(det_sig)
}

entropia <- normal_entropy(k = 2, pi = pi, det_sig)
print(entropia) # Should return a value close to 4.3997

result <- entropy_kde2d(x, y, n_grid = 50)
print(result) # Should return a value close to 4.2177

}
