% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{confint.ypbp}
\alias{confint.ypbp}
\title{Confidence intervals for the regression coefficients}
\usage{
\method{confint}{ypbp}(object, level = 0.95, ...)
}
\arguments{
\item{object}{an object of the class ypbp.}

\item{level}{the confidence level required.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence limits for the regression coefficients. These will be labeled as (1-level)/2 and 1 - (1-level)/2 in \% (by default 2.5\% and 97.5\%).
}
\description{
This function returns the estimated confidence intervals for the regression coefficients when the maximum likelihood estimation approach is used in the model fitting.
}
\examples{
\donttest{
fit <- ypbp(Surv(time, status)~arm, data=ipass)
confint(fit)
}

}
