% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Factorial.Double.R
\name{Factorial.Double}
\alias{Factorial.Double}
\alias{A000165}
\alias{A001147}
\title{Double Factorial of even or odd numbers}
\usage{
Factorial.Double(n, gmp = TRUE, odd = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{odd}{a logical; \code{TRUE} for double factorial of odd numbers, \code{FALSE} for even numbers.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000165}{A000165} and \href{https://oeis.org/A001147}{A001147}, a \emph{Double Factorial} is the factorial of numbers with same parity.
For example, if \eqn{n=5}, then \eqn{n!!=5*3*1}. Please be aware that this function
returns either even- or odd-valued numbers' double factorials per the
use of \code{odd} parameter.
}
\examples{
\donttest{
## generate first 10 double factorials
print(Factorial.Double(10))
}

}
\seealso{
\code{\link{Factorial}}
}
